#!/usr/bin/perl
#
# generateMessageServers.pl

use strict;
use Getopt::Long;
use Term::ReadKey;

my $wingui_msgservers				= "./sapmsg.ini";
my $wingui_services					= "./services";
my $javagui_msgservers			= "./messageservers.txt";
my $javagui_systemdesc			= "./systemdesc.txt";
my $debug = 0;
my $version = 0.6;
my $key;
my $overwrite;

Getopt::Long::Configure( 'no_ignore_case' );
Getopt::Long::Configure( 'bundling' );

my $options = GetOptions( 'm|winmsg:s'			=>	\$wingui_msgservers,
													's|winservices:s'	=>  \$wingui_services,
													'j|javamsg:s'			=>	\$javagui_msgservers,
													'd|javadesc:s'		=>	\$javagui_systemdesc,
													'o|overwrite'			=>	\$overwrite,
													'h|help:s'				=>  sub { printhelp(); exit; },
													'v|version:s'			=>	sub { printversion(); exit; } );

open SAPMSG,								"<$wingui_msgservers"		or die "Open $wingui_msgservers failed: $!";
open SERVICES,							"<$wingui_services"			or die "Open $wingui_services failed: $!";

if ($overwrite != "1") {
	if (-e $javagui_msgservers) {
		ReadMode('cbreak');
		print "The specified output file <" . $javagui_msgservers . "> already exists. Do you want to overwrite it? [y/n]";
		$key = ReadKey(0);
		ReadMode('normal');
		if ($key  ne "y") {
			print "\nExiting...\n";
	   	exit;
		}
		else {
			print "\nOverwriting existing file...\n";
		}
	}
	if (-e $javagui_systemdesc) {
		ReadMode('cbreak');
		print "The specified output file <" . $javagui_systemdesc . "> already exists. Do you want to overwrite it? [y/n]";
		$key = ReadKey(0);
		ReadMode('normal');
		if ($key  ne "y") {
			print "\nExiting...\n";
	   	exit;
		}
		else {
			print "\nOverwriting existing file...\n";
		}
	}
	
}

open JAVAGUI_MSGSERVERS,			">$javagui_msgservers"			or die "Open $javagui_msgservers failed: $!\n";

convert_message_servers();

close SERVICES;
close JAVAGUI_MSGSERVERS;
close SAPMSG;

open JAVAGUI_SYSTEMDESC,			">$javagui_systemdesc"	or die "Open $javagui_systemdesc failed: $!\n";
open SAPMSG,									"<$wingui_msgservers"		or die "Open $wingui_msgservers failed: $!";

convert_system_descriptions();

close SAPMSG;
close JAVAGUI_SYSTEMDESC;


sub convert_message_servers {
	print "DEBUG: Converting Message Servers...\n\n" if ($debug);
	my @javagui_msgservers_list;
	my %hosts = ();
	while(<SAPMSG>)
	{
	  s/(\015|\012)+$//;
	  last if /\[Message Server Description\]/;
	  next if /\[Message Server\]/;
	  my ($system, $name) = split /=/;
	  $hosts{$system}=$name;
	}
	while(<SERVICES>)
	{
	   s/(\015|\012)+$//;	
	   my $line = $_;
	   if($line =~/^sapms/) {
	     $line =~s/#.*$//g;
	     $line =~ s/[ \t]+/ /g;
	     (my $col1, my $col2, my $col3) = split / /, $line,3;
	     chomp($col1);
	     chomp($col2);
	     chomp($col3);	     	     
	     print "DEBUG: col1 = <" . $col1 . ">, col2 = <" . $col2 . ">, col3 = <" . $col3 . ">\n" if ($debug);
	     $col1 = "$col1 $col3";	
	     (my $port) = $col2 =~ /(\d+)/;
	     chomp($port);
	     print "DEBUG: port = <", $port, ">\n" if ($debug);
	     $col1 =~ s/^\s*//;
	     $col1 =~ s/\s*$//;	
	     print "DEBUG: col1 = <", $col1, ">\n" if ($debug);
	     my @names  = split /\s+/, $col1;
	     foreach my $system (@names)
	     {
	        $system =~ s/^sapms//;
	        if ($port)
	        {
	        	print "DEBUG: system = <" . $system . ">, host von system = <" . $hosts{$system} . ">, port = <" . $port . ">\n" if ($debug);
	        	my $entry = "$system : /H/" . $hosts{$system} . "/S/$port\n" if $hosts{$system};
	        	print "DEBUG: entry = <" . $entry . ">\n" if ($debug);
	        	print "-----------------------------------------------\n" if ($debug);
	        push (@javagui_msgservers_list, $entry);
	        }
	        else
	        {
	        	my $entry = "# $system : /H/" . $hosts{$system} . "/S/" . $port . "\n" if $hosts{$system};
	        push (@javagui_msgservers_list, $entry);
	        }
	     }
	   }
	}
	foreach (@javagui_msgservers_list) {
		print JAVAGUI_MSGSERVERS $_;
	}
}

sub convert_system_descriptions {
	my $start = 0;
	while(<SAPMSG>)
	{
	  s/(\015|\012)+$//;
	  my $line = $_;
	  if ( $line =~ /\[Message Server Description\]/ ) {
	  	$start = 1;
	  	next;
	  }
	  if ( $start == 1 ) {
			print "DEBUG: line = <", $line, ">\n" if ($debug);
	  	$line =~ /^(\S*)=(.*)$/;
	  	my $sid = $1;
	  	my $desc = $2;
	  	$desc =~ s/\\/\\\\/g;
	  	$desc =~ s/:/\\:/g;
			print "DEBUG: sid = <" . $sid . ">, desc = <" . $desc . ">\n" if ($debug);
	  	my $output = $sid . ":" . $desc . "\n";
			print JAVAGUI_SYSTEMDESC $output;
		}
	}
}

sub printhelp {
	print "Syntax: generateMessageServers.pl [-m filename] [-s filename] [-j filename]\n";
	print "-m | --winmsg:        <WinGUI Message Servers File>            (INPUT FILE,  default: ./sapmsg.ini)\n";
	print "-s | --winservices:   <WinGUI Services File>                   (INPUT FILE,  default: ./services)\n";
	print "-j | --javamsg:       <JavaGUI Message Servers File>           (OUTPUT FILE, default: ./messageservers.txt)\n";
	print "-d | --javadesc:      <JavaGUI System Description File>        (OUTPUT FILE, default: ./systemdesc.txt)\n";
	print "-o | --overwrite:     Overwrites an existing output file without prompting.\n";	
	print "-h | --help:          Prints this help text.\n";
	print "-v | --version:       Prints the version of this script.\n";
}

sub printversion {
	print "Version: " . $version . "\n";
}